//Cpation: Design of FIR LPF Filter using Frequecny Sampling Technique

clear;
clc;
close;
M =15;
Hr = [1,1,1,1,0.4,0,0,0];
for k =1:length(Hr)
    G(k)=((-1)^(k-1))*Hr(k);
end
h = zeros(1,M);
U = (M-1)/2
for n = 1:M
  h1 = 0;
  for k = 2:U+1
    h1 =G(k)*cos((2*%pi/M)*(k-1)*((n-1)+(1/2)))+h1; 
  end
 h(n) = (1/M)* (G(1)+2*h1);
end
disp(h,'Filter Coefficients are h(n)=')
[hzm,fr]=frmag(h,256);
hzm_dB = 20*log10(hzm)./max(hzm);
subplot(2,1,1)
plot(2*fr,hzm)
a=gca();
xlabel('Normalized Digital Frequency W');
ylabel('Magnitude');
title('Frequency Response 0f FIR LPF using Frequency Sampling Technique with M = 15 with Cutoff Frequency = 0.466')
xgrid(2)
subplot(2,1,2)
plot(2*fr,hzm_dB)
a=gca();
xlabel('Normalized Digital Frequency W');
ylabel('Magnitude in dB');
title('Frequency Response 0f FIR LPF using Frequency Sampling Technique with M = 15 with Cutoff Frequency = 0.466')
xgrid(2)
//Result
//Filter Coefficients are h(n)=   
//column 1 to 7
// 
// -0.0141289  -0.0019453  0.04  0.0122345  -0.0913880  -0.0180899  0.3133176  
// 
//column  8 to 14
// 
//0.52    0.3133176  - 0.0180899  - 0.0913880    0.0122345    0.04  - 0.0019453  
// 
//column 15
// 
//  - 0.0141289  